/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.commands.commands;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.systems.commands.Command;
import Krasnodar.rockstarnew.systems.commands.CommandBuilder;
import Krasnodar.rockstarnew.systems.commands.CommandContext;
import Krasnodar.rockstarnew.systems.commands.ValidationResult;
import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.player.ClientPlayerTickEvent;
import Krasnodar.rockstarnew.systems.localization.Localizator;
import Krasnodar.rockstarnew.utility.game.EntityUtility;
import Krasnodar.rockstarnew.utility.game.MessageUtility;
import Krasnodar.rockstarnew.utility.interfaces.IMinecraft;
import Krasnodar.rockstarnew.utility.rotations.Rotation;
import Krasnodar.rockstarnew.utility.rotations.RotationHandler;
import Krasnodar.rockstarnew.utility.time.Timer;
import net.minecraft.class_1268;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2886;
import net.minecraft.class_2902;

public class AutoPilotCommand
implements IMinecraft {
    private final Timer timer = new Timer();
    private class_243 target;
    private boolean active;
    private final EventListener<ClientPlayerTickEvent> onTick = event -> {
        class_243 currentTarget;
        if (this.active && AutoPilotCommand.mc.field_1724 != null && AutoPilotCommand.mc.field_1687 != null && (currentTarget = this.target) != null && AutoPilotCommand.mc.field_1724.method_6128()) {
            class_243 vec = currentTarget.method_1020(AutoPilotCommand.mc.field_1724.method_33571()).method_1029();
            float rawYaw = (float)Math.toDegrees(Math.atan2(-vec.field_1352, vec.field_1350));
            int highestY = (int)AutoPilotCommand.mc.field_1724.method_23318();
            int highestX = (int)currentTarget.field_1352;
            int highestZ = (int)currentTarget.field_1350;
            int iterations = 80;
            for (int x = -iterations; x < iterations; ++x) {
                for (int z = -iterations; z < iterations; ++z) {
                    int height = AutoPilotCommand.mc.field_1687.method_8624(class_2902.class_2903.field_13202, (int)(AutoPilotCommand.mc.field_1724.method_23317() + (double)x), (int)(AutoPilotCommand.mc.field_1724.method_23321() + (double)z)) + 5;
                    if (height <= highestY || !((double)height > AutoPilotCommand.mc.field_1724.method_23318())) continue;
                    highestY = height;
                    highestX = (int)(AutoPilotCommand.mc.field_1724.method_23317() + (double)x);
                    highestZ = (int)(AutoPilotCommand.mc.field_1724.method_23321() + (double)z);
                }
            }
            AutoPilotCommand.mc.field_1690.field_1867.method_23481(true);
            AutoPilotCommand.mc.field_1690.field_1894.method_23481(true);
            if (EntityUtility.getVelocity() < 1.46 && this.timer.finished(1700L)) {
                AutoPilotCommand.mc.field_1761.method_41931(AutoPilotCommand.mc.field_1687, sequence -> new class_2886(class_1268.field_5810, sequence, Rockstar.getInstance().getRotationHandler().getServerRotation().getYaw(), Rockstar.getInstance().getRotationHandler().getServerRotation().getPitch()));
                this.timer.reset();
            }
            class_243 vecHeight = new class_243((double)highestX, (double)(highestY + 23), (double)highestZ).method_1020(AutoPilotCommand.mc.field_1724.method_33571()).method_1029();
            float rawPitch = (float)Math.clamp(Math.toDegrees(Math.asin(-vecHeight.field_1351)), -89.0, 89.0);
            int i = AutoPilotCommand.mc.field_1687.method_8624(class_2902.class_2903.field_13202, (int)AutoPilotCommand.mc.field_1724.method_23317(), (int)AutoPilotCommand.mc.field_1724.method_23321()) - 10;
            while ((double)i < AutoPilotCommand.mc.field_1724.method_23318()) {
                if (!AutoPilotCommand.mc.field_1687.method_8320(new class_2338((int)AutoPilotCommand.mc.field_1724.method_23317(), i, (int)AutoPilotCommand.mc.field_1724.method_23321())).method_26227().method_15769() && AutoPilotCommand.mc.field_1724.method_23318() - (double)i < 5.0) {
                    rawPitch -= 11.0f;
                    break;
                }
                ++i;
            }
            if (AutoPilotCommand.mc.field_1724.method_19538().method_1025(currentTarget) < 20.0) {
                MessageUtility.info(class_2561.method_30163((String)Localizator.translate("commands.autopilot.stopped")));
                this.stopAutoPilot();
            }
            RotationHandler rotationHandler = Rockstar.INSTANCE.getRotationHandler();
            Rotation targetRotation = new Rotation(rawYaw, rawPitch + 13.0f);
            rotationHandler.rotate(targetRotation);
        }
    };

    private void initialize() {
        Rockstar.getInstance().getEventManager().subscribe(this);
    }

    public AutoPilotCommand() {
        this.initialize();
    }

    public Command command() {
        return CommandBuilder.begin("autopilot").aliases("ap", "pilot", "\u0430\u0432\u0442\u043e\u043f\u0438\u043b\u043e\u0442", "\u043f\u0438\u043b\u043e\u0442").desc("commands.autopilot.description").param("x", p -> p.optional().validator(AutoPilotCommand::verifyCoordinate)).param("y", p -> p.optional().validator(AutoPilotCommand::verifyCoordinate)).param("z", p -> p.optional().validator(AutoPilotCommand::verifyCoordinate)).handler(this::handle).build();
    }

    private static ValidationResult verifyCoordinate(String input) {
        try {
            Double.parseDouble(input);
            return ValidationResult.ok(input);
        }
        catch (NumberFormatException var2) {
            return ValidationResult.error(Localizator.translate("commands.autopilot.invalid"));
        }
    }

    private void handle(CommandContext ctx) {
        String x = (String)ctx.arguments().get(0);
        String y = (String)ctx.arguments().get(1);
        String z = (String)ctx.arguments().get(2);
        if (x != null && y != null && z != null) {
            try {
                this.target = new class_243(Double.parseDouble(x), Double.parseDouble(y), Double.parseDouble(z));
                this.active = true;
                MessageUtility.info(class_2561.method_30163((String)Localizator.translate("commands.autopilot.start", this.target.method_10216(), this.target.method_10214(), this.target.method_10215())));
            }
            catch (NumberFormatException var6) {
                MessageUtility.error(class_2561.method_30163((String)Localizator.translate("commands.autopilot.invalid")));
            }
        } else if (this.active) {
            this.stopAutoPilot();
            MessageUtility.info(class_2561.method_30163((String)Localizator.translate("commands.autopilot.stopping")));
        } else {
            MessageUtility.error(class_2561.method_30163((String)Localizator.translate("commands.autopilot.not_active")));
        }
    }

    private void stopAutoPilot() {
        this.active = false;
        this.target = null;
        Rockstar.getInstance().getEventManager().unsubscribe(this);
        AutoPilotCommand.mc.field_1690.field_1867.method_23481(false);
        AutoPilotCommand.mc.field_1690.field_1894.method_23481(false);
    }
}

